/*******

MICE server

copyright 2001, 2002, Alan H. Clifford.

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your option)
any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc., 59
Temple Place, Suite 330, Boston, MA 02111-1307 USA


Alan Clifford can be contacted at mice@clifford.ac

Latest version at http://www.clifford.ac

$Id: mice.server.files.c,v 1.25 2002/07/15 22:54:33 alan Exp $
$Name: release4_2 $

*******/

#include "mice.server.h"

// #define DEMODATA "./mice.demo.conf"

#ifndef DEFAULTAYTVALUE
#define DEFAULTAYTVALUE 10
#endif

static MICEISP const * readisps(const char * datafile);
static MICEISP * check_current_isp(char * shortname_p, int flag);
// static int readayt(const char * datafile);
static int *readayt(const char * datafile);

// first call to getisps() will read the data file otherwise it will return a pointer to
// the static title.

// get_current_isp returns a pointer to a static which contains a copy of the current isp data, not
// a pointer to the linked list of isps

// set_current_isp() will cause a read of the conf file if this hasn't already been done.

// rereadips is called from the signal handler to set the reread flag.  If the flag is set,
// a call to do the reread will reread the conf file.  This reread should be done from the select
// loop when there are no connections.


MICEISP * get_current_isp(void)
{
    // returns the current isp
    // string could be ""
    return check_current_isp(NULL, 0);
}

MICEISP * set_current_isp(char * shortname_p)
{
    // returns the current isp
    // string could be ""
    // remove leading spaces
    // while (' ' == *shortname_p && '\0' != *shortname_p) ++shortname_p;
    while (' ' == *shortname_p) ++shortname_p;
    return check_current_isp(shortname_p, 1);
}

static MICEISP * check_current_isp(char * shortname_p, int flag)
{
    // returns a pointer to a static MICEISP. Strings could be ""
    static MICEISP current_isp = {"","", NULL};
    if (0 == flag) {
        // get
        // do nothing as pointer is returned
    }
    else if ((1 == flag) && (NULL != shortname_p)) {
        // set
        MICEISP const  *check_isp_p = getisps();  // cannot be null
        *(current_isp.shortname) = '\0';
        *(current_isp.longname) = '\0';
        for (check_isp_p = check_isp_p->next;
             check_isp_p != NULL;
             check_isp_p = check_isp_p->next) {
            if (!strcmp(shortname_p, check_isp_p->shortname)) {
                //found
                strcpy(current_isp.shortname, check_isp_p->shortname);
                strcpy(current_isp.longname, check_isp_p->longname);
                break;
            }
        }
    }

    return &current_isp;
}


MICEISP const  *getisps(void)
{
    static MICEISP const * title_p = NULL;
    // read the file if it hasn't been read
    if (NULL == title_p) {
        title_p = readisps(Params2p->conf);  // cannot be NULL
    }
    return title_p;
}

void showisps(void)
// used by the server after startup
{
    MICEISP const  *miceisp_p = getisps(); // start of linked list of isp names
    // miceisp_p cannot be NULL
    while (NULL != (miceisp_p = miceisp_p->next)) {
        printf("%20s%s\n%20s%s\n",
               "isp:  ", miceisp_p->shortname,
               " ",  miceisp_p->longname);
    }
    printf("\n");
}


int rereadisps(int action)
// action == 1 used in usr1 signal handler to set the flag that the isps should be
// reread from the conf file.
// action == 0 rereads the conf file if the flage is set.  This should be called from the
// select loop when there are no connections
{
    static int flag = 0;
    int rc = 0;  // return non-zero if readisps called
    if (1 == action) flag = 1;
    else if ((0 == action) && (1 == flag)) {
        flag = 0;  // reset flag
        rc = 1;
        readisps(Params2p->conf);
    }
    // else ignore
    return rc;
}


static MICEISP const * readisps(const char * datafile)
{
    // read isps from file
    // returns a pointer to the first ie title
    // 2nd is the default isp if the file isn't opened or none read from file
    static MICEISP title = {"shortname", "Long ISP name", NULL};
    static char *defaultshort =  "default"; // used if unable to open data file
    static char *defaultlong = "Default ISP";
    MICEISP *isp_p, *delisp_p,  *newisp_p;
    FILE *data_fp = NULL;
    char data_buff[CONFDATALEN + 1];

    // remove the linked list if it exists

    isp_p = title.next;
    while (isp_p != NULL) {
        delisp_p = isp_p;
        isp_p = isp_p->next;
        // keep printf for debugging
        // printf("delete %p\n", delisp_p);
        free(delisp_p);
    }

    isp_p = &title;
    isp_p->next = NULL;

    // open the file
    if (NULL != (data_fp = fopen(datafile, "r"))) {
        char *ptr_b, *ptr_s, *ptr_l, *ptr;
        int ctr = 0;
        while (NULL != (ptr_b = fgets(data_buff, CONFDATALEN + 1, data_fp))) {
            *(data_buff + CONFDATALEN) = '\0';
            ++ctr;  // file line
            // remove the EOL
            if (NULL != (ptr = strchr(data_buff, '\n'))) *ptr = '\0';
            // perhaps read and discard any very long lines here.
            // remove leading spaces, tabs
            while (isspace(*ptr_b)) ++ptr_b;
            // is it an isp line?
            if (!(strncasecmp("isp", ptr_b, 3)) && (isspace(*(ptr_b + 3)))) {
                ptr_s = NULL;
                ptr_l = NULL; // could be left over so make null
                // printf("%d databuffer [%s]\n", ctr, data_buff);
                // printf("dataptr [%s]\n", ptr_b);
                // parse the line for shortname
                if (NULL != (ptr_s = strpbrk(ptr_b, " \t"))) {
                    // remove leading spaces, tabs
                    while (isspace(*ptr_s)) ++ptr_s;
                    // parse the line for end of short name name
                    if (NULL != (ptr_l = strpbrk(ptr_s, " \t"))) {
                        *ptr_l = '\0';
                        ++ptr_l;
                        // remove leading spaces, tabs
                        while (isspace(*ptr_l)) ++ptr_l;
                        // remove trailing spaces, tabs
                        // Long name can have embedded spaces
                        ptr = strchr(ptr_l, '\0');
                        while (ptr > ptr_l) {  // could start being equal
                            --ptr;  // get off the '\0' first time
                            if (isspace(*ptr)) *ptr = '\0';
                            else break;  // dont't go into the characters
                        }
                    }
                }
                // if (NULL != ptr_s) printf("<%s>\n", ptr_s);
                // if (NULL != ptr_l) printf("<<%s>>\n", ptr_l);
                // store complete isps
                if ((NULL != ptr_s) && (NULL != ptr_l)
                    && ('\0' != *ptr_s) && ('\0' != *ptr_l)) {
                    // printf("OK <%s> <<%s>>\n", ptr_s, ptr_l);
                    if (NULL != (newisp_p = malloc(sizeof(MICEISP)))) {
                        strncpy(newisp_p->shortname, ptr_s, ISPSHORTNAMELEN);
                        *(newisp_p->shortname + ISPSHORTNAMELEN) = '\0';
                        strncpy(newisp_p->longname, ptr_l, ISPLONGNAMELEN);
                        *(newisp_p->longname + ISPLONGNAMELEN) = '\0';
                        // update linked list
                        newisp_p->next = NULL;
                        isp_p = isp_p->next = newisp_p;
                        // keep for debugging
                        // printf("isp <%s> <<%s>>\n", isp_p->shortname, isp_p->longname);
                    }
                }
            }
            else continue;  // not an isp line
        }
        // keep for debugging
        // fputs("\n", stdout);
        if (0 != fclose(data_fp)) { // don't reset data_fp to NULL, needed for test below
            perror("fclose data file");
        }
    }
    // if no isp read from file or file not opened
    if ((NULL == data_fp) || (NULL == title.next)) {
        // file not opened or no isp
        if (NULL != (newisp_p = malloc(sizeof(MICEISP)))) {
            strncpy(newisp_p->shortname, defaultshort, ISPSHORTNAMELEN);
            *(newisp_p->shortname + ISPSHORTNAMELEN) = '\0';
            strncpy(newisp_p->longname, defaultlong, ISPLONGNAMELEN);
            *(newisp_p->longname + ISPLONGNAMELEN) = '\0';
            // update linked list
            newisp_p->next = NULL;
            isp_p = isp_p->next = newisp_p;
            // keep for debugging
            // printf("isp <%s> <<%s>>\n", isp_p->shortname, isp_p->longname);
        }
        // keep for debugging
        // fputs("\n", stdout);
    }
    return &title;
}

/*****************************************/
// AYT

int getayt(void)
{
    static int *ayt_p = NULL;
    // read the file if it hasn't been read
    if (NULL == ayt_p) {
        ayt_p = readayt(Params2p->conf);
    }
    // printf("In getayt <%d>\n", *ayt_p);
    return *ayt_p;
}


int rereadayt(int action)
// action == 1 used in usr1 signal handler to set the flag that the ayt should be
// reread from the conf file.
// action == 0 rereads the conf file if the flage is set.  This should be called from the
// select loop when there are no connections
{
    static int flag = 0;
    int rc = 0;  // return non-zero if readisps called
    if (1 == action) flag = 1;
    else if ((0 == action) && (1 == flag)) {
        flag = 0;  // reset flag
        rc = 1;
        readayt(Params2p->conf);
    }
    // else ignore
    return rc;
}


static int *readayt(const char * datafile)
{
    // read ayt from file
    FILE *data_fp = NULL;

    char data_buff[CONFDATALEN + 1];
    // static int ayt = 0; // off
    static int ayt = 0;
    // static because we return a pointer to it in getayt() but the value may be updated
    // when called from rereadayt()
    ayt = 0; // always reset to 0, off
 
    // printf("%s <%d>\n", "Looking for AYT, default is", ayt);

    // open the file
    if (NULL != (data_fp = fopen(datafile, "r"))) {
        char *ptr_b, *ptr_s, *ptr;
        int ctr = 0;
        while (NULL != (ptr_b = fgets(data_buff, CONFDATALEN + 1, data_fp))) {
            *(data_buff + CONFDATALEN) = '\0';
            ++ctr;  // file line
            // remove the EOL
            if (NULL != (ptr = strchr(data_buff, '\n'))) *ptr = '\0';
            // perhaps read and discard any very long lines here.
            // remove leading spaces, tabs
            while (isspace(*ptr_b)) ++ptr_b;
            // is it an ayt line?
            // ayt on its own or with a space
            if (!(strncasecmp("ayt", ptr_b, 3)) && ((isspace(*(ptr_b + 3))) || ('\0' == *(ptr_b + 3)))) {
                ptr_s = NULL;  // reset
                // printf("\ntry ayt string = <%s>\n", ptr_b);
                // printf("%d databuffer [%s]\n", ctr, data_buff);
                // printf("dataptr [%s]\n", ptr_b);
                // parse the line for number
                if (NULL != (ptr_s = strpbrk(ptr_b, " \t"))) {
                    // remove leading spaces, tabs
                    while (isspace(*ptr_s)) ++ptr_s;
                    // move to end of numeric
                    ptr = ptr_s;
                    while (isdigit(*ptr)) ++ptr;
                    *ptr = '\0';
                }
                // string of number is at ptr_s
                // if (NULL != ptr_s) printf("try ayt string = <%s>\n", ptr_s);

                if ((NULL == ptr_s) || ('\0' == *ptr_s)) {
                    ayt = DEFAULTAYTVALUE;
                    // printf("Default ayt = <%d>\n", ayt);
                }

                // if ((NULL != ptr_s) && ('\0' != *ptr_s)) {
                else {
                    // check for numeric
                    // return numeric number or DEFAULTAYTVALUE  if error
                    unsigned long ayt_ul;
                    char *endptr;
                    // printf("ayt string = <%s>\n", ptr_s);
                    ayt_ul = strtoul(ptr_s, &endptr, 10);
                    // printf("ayt_ul <%lu>\n", ayt_ul);
                    if (('\0' == *endptr) && (INT_MAX >= ayt_ul) && (1 < ayt_ul)) {
                        // number >= 2, <= INT_MAX
                        ayt = (int)ayt_ul;
                    }
                    else ayt = DEFAULTAYTVALUE;
                    // printf("ayt = <%s> <%d>\n", ptr_s, ayt);
                }
            }
            // else continue;  // not an ayt line
        }
        if (0 != fclose(data_fp)) {
            perror("fclose data file");
        }
        else data_fp = NULL;
    }
    // printf("final ayt = <%d>\n", ayt);

    return &ayt;
}


/*******************************************/









char * readscriptdir(const char * datafile)
{
    // read script dir from conf file
    // returns a pointer to the directory name in malloced memory or NULL
    FILE *data_fp = NULL;
    char data_buff[CONFDATALEN + 1];
    static char * rc_p = NULL;
    char *ptr_s = NULL;
    // clear up if function is called a second time
    if (NULL != rc_p) {
        free(rc_p);
        rc_p = NULL;
    }

    // open the file
    if (NULL != (data_fp = fopen(datafile, "r"))) {
        char *ptr_b,  *ptr;
        int ctr = 0;
        while (NULL != (ptr_b = fgets(data_buff, CONFDATALEN + 1, data_fp))) {
            *(data_buff + CONFDATALEN) = '\0';
            ptr_s = NULL;
            ++ctr;  // file line
            // remove the EOL
            if (NULL != (ptr = strchr(data_buff, '\n'))) *ptr = '\0';
            // perhaps read and discard any very long lines here.
            // remove leading spaces, tabs
            while (isspace(*ptr_b)) ++ptr_b;
            // is it a script directory  line?
            if (!(strncasecmp("scriptdir", ptr_b, 9)) && (isspace(*(ptr_b + 9)))) {
                // ptr_s = NULL;
                // printf("%d databuffer [%s]\n", ctr, data_buff);
                // printf("dataptr [%s]\n", ptr_b);
                // parse the line for directory name
                if (NULL != (ptr_s = strpbrk(ptr_b, " \t"))) {
                    // remove leading spaces, tabs
                    while (isspace(*ptr_s)) ++ptr_s;
                    // remove trailing spaces, tabs
                    // Directory names can have enbedded spaces
                    ptr = strchr(ptr_s, '\0');
                    while (ptr > ptr_s) {  // could start being equal
                        --ptr;  // get off the '\0' first time
                        if (isspace(*ptr)) *ptr = '\0';
                        else break;  // dont't go into the characters
                    }

                }
                if (NULL != ptr_s) break;
            }
            // else continue;  // not an isp line
        }
        // keep for debugging
        // fputs("\n", stdout);
        if (0 != fclose(data_fp)) { // don't reset data_fp to NULL, needed for test below
            perror("fclose data file");
        }
    }
    // check if it is a directory and is accessible
    if (NULL != ptr_s) {
        char *ptr;
        // check this file exists
        struct stat statbuff;
        if (0 != stat(ptr_s, &statbuff)) {
            perror(ptr_s);
        }
        else if (!(S_ISDIR(statbuff.st_mode))) {
            // and is a regular file
            fprintf(stderr, "%s: not a directory\n", ptr_s);
        }
        else if (0 != access(ptr_s, X_OK)) {
            // and is accessable
            perror(ptr_s);
        }
        else if (NULL != (ptr = realloc(rc_p, strlen(ptr_s) + 1))) {
            rc_p = ptr;
            strcpy(rc_p, ptr_s);
            // keep for debugging
            // printf("<%s>\n", rc_p);
        }
    }

    return rc_p;
}





void switch_off_stdout(void)
{
    struct stat statbuffer;
    // look for /dev/null
    if (-1 == stat("/dev/null", &statbuffer)) {
        perror("stat devnull");
        close(STDOUT_FILENO);
    }
    else if (statbuffer.st_mode & S_IWUSR) {
        // write mode
        // puts("Can write to /dev/null");
        if (NULL == freopen("/dev/null", "a", stdout)) {
            perror("freeopen null");
            close(STDOUT_FILENO);
        }
        else {
            printf("%s\n", "This should not be seen");
        }
    }
}


void switch_off_stderr(void)
{
    // FILE *mytty;
    struct stat statbuffer;
    // look for /dev/null
    if (-1 == stat("/dev/null", &statbuffer)) {
        perror("stat devnull");
        close(STDERR_FILENO);
    }
    else if (statbuffer.st_mode & S_IWUSR) {
        // write mode
        // puts("Can write to /dev/null");
        // fprintf(stderr, "%s\n", "testing This is stderr");
        if (NULL == freopen("/dev/null", "a", stderr)) {
            perror("freeopen null");
            close(STDERR_FILENO);
        }
        else {
            fprintf(stderr, "%s\n", "This should not be seen");
        }
    }
}

void switch_off_stdin(void)
{
    // FILE *mytty;
    struct stat statbuffer;
    // look for /dev/null
    if (-1 == stat("/dev/null", &statbuffer)) {
        perror("stat devnull");
        close(STDIN_FILENO);
    }
    else if (statbuffer.st_mode & S_IRUSR) {
        if (NULL == freopen("/dev/null", "r", stdin)) {
            perror("freeopen null");
            close(STDIN_FILENO);
        }
    }
}

int check_exec_access(void)
// returns 0 if OK, otherwise non-zero
{
    int rc = 0;
    rc = rc + check_exec_access_2(Params2p->execconnect);
    rc = rc + check_exec_access_2(Params2p->execinfo);
    rc = rc + check_exec_access_2(Params2p->execkillconnect);
    rc = rc + check_exec_access_2(Params2p->execkillinfo);
    check_read_access_2(Params2p->conf);  // produce warning only
    return rc;
}

int check_exec_access_2(char const *prog)
{
    int rc = 0;
    if (-1 == access(prog, X_OK)) {
        int errornumber = errno;
        fprintf(stderr, "%s execute access error:  %s\n", prog, strerror(errornumber));
        syslog(LOG_USER | LOG_INFO, "%s execute access error:  %s", prog, strerror(errornumber));
        // perror("execute access");
        ++rc;
    }
    return rc;
}

int check_read_access_2(char const *filename)
{
    int rc = 0;
    if (NULL != filename) {
        if (-1 == access(filename, R_OK)) {
            int errornumber = errno;
            fprintf(stderr, "%s read access error:  %s\n", filename, strerror(errornumber));
            syslog(LOG_USER | LOG_INFO, "%s read access error:  %s", filename, strerror(errornumber));
            // perror("execute access");
            ++rc;
        }
    }
    return rc;
}


void sigusr1_handler(int s)
// SIGUSR1 used to reload the conf file
{
    // keep for debugging
    // puts("usr 1 signal");
    rereadisps(1);
    rereadayt(1);
}

